#####################################################
### Création de la fenêtre "Limites du programme" ###
#####################################################

import tkinter

### La fonction qui sera appelée par le programme principal pour
### ouvrir la fenêtre

def principale(rien):
    '''Affiche la fenêtre explicative des limites du programme.'''
    f_limites = tkinter.Toplevel()
    f_limites.title("Limites du programme")
    f_limites.focus_force()
    texte = """Le programme est susceptible d'indiquer des résultats \
erronés si les molécules sélectionnées ont des substituants complexes. \
Dans le cas où le substituant gênant est un cycle aromatique, une \
deuxième entrée de la molécule dans le menu de sélection est disponible \
et permet d'ignorer le cycle aromatique."""


    widget_texte = tkinter.Label(f_limites, text = texte, wraplength = 400,\
                                 anchor=tkinter.W, justify=tkinter.LEFT)
    widget_texte.pack()
    
    f_limites.resizable(width = False, height = False)
    f_limites.mainloop()
